Rem
Rem $Header: trans_setup.sql 18-jan-2007.14:54:49 chall Exp $
Rem
Rem trans_setup.sql
Rem
Rem Copyright (c) 2003, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      trans_setup.sql - Creates transformations used with this sample.
Rem
Rem    DESCRIPTION
Rem      This script creates a PL/.SQL package, mgw_xml_demo, that contains
Rem      two transformation functions and then registers two transformations
Rem      using the DBMS_TRANSFORM package.
Rem
Rem      One function, order_to_basic, transforms a payload of type
Rem      MGWUSER.BOOK_ORDER_T into a payload of type SYS.MGW_BASIC_MSG_T 
Rem      (a Messaging Gateway canonical type). The other function, 
Rem      basic_to_order, transforms a payload of type SYS.MGW_BASIC_MSG_T 
Rem      into a payload of type MGWUSER.BOOK_ORDER_T.
Rem
Rem      These two transformation functions are registered using the 
Rem      procedure DBMS_TRANSFORM.CREATE_TRANSFORMATION. The transformation
Rem      names registered are MGWUSER.ORDER2BASIC and MGWUSER.BASIC2ORDER.
Rem
Rem    NOTES
Rem

connect mgwuser/mgwuser
set serveroutput on

prompt
prompt Creating transformation package
prompt

CREATE OR REPLACE PACKAGE mgw_xml_demo AS

  FUNCTION order_to_basic(book_order IN book_order_t)
  RETURN sys.mgw_basic_msg_t;

  FUNCTION basic_to_order(basic IN sys.mgw_basic_msg_t)
  RETURN book_order_t;

END mgw_xml_demo;
/

CREATE OR REPLACE PACKAGE BODY mgw_xml_demo AS

   FUNCTION order_to_basic(book_order IN book_order_t)
   RETURN sys.mgw_basic_msg_t 
   IS
       v_xml   XMLType;
       v_text  varchar(2000);
       v_basic sys.mgw_basic_msg_t;
   BEGIN
       -- create a XMLType object from the book_order object
       v_xml  := XMLType.createXML(book_order, null, null);

       -- convert the XMLType object to XML document
       v_text := v_xml.getStringVal();

       -- store the XML document in a mgw_basic_msg_t object
       v_basic := sys.mgw_basic_msg_t.construct;
       v_basic.text_body := sys.mgw_text_value_t(v_text, null);

       return v_basic;

   END order_to_basic;

   FUNCTION basic_to_order(basic IN sys.mgw_basic_msg_t)
   RETURN book_order_t 
   IS 
       v_xml     XMLType;
       v_text    varchar(2000);
       v_order  mgwuser.book_order_t;
   BEGIN
       --if (basic.text_body is NULL) 
       --else
       v_text := basic.text_body.small_value;

       v_xml := XMLType.createXML(v_text);

       v_xml.toObject(v_order);

       return v_order;
   END basic_to_order;

END mgw_xml_demo;
/

grant execute on mgw_xml_demo to PUBLIC;

prompt
prompt Creating BASIC2ORDER transformation
prompt

begin
  dbms_transform.create_transformation(
    schema      => 'mgwuser',
    name        => 'basic2order',
    from_schema => 'sys',
    from_type   => 'mgw_basic_msg_t',
    to_schema   => 'mgwuser',
    to_type     => 'book_order_t',
    transformation => 'mgwuser.mgw_xml_demo.basic_to_order(source.user_data)');
end;
/

prompt
prompt Creating ORDER2BASIC transformation
prompt

begin
  dbms_transform.create_transformation(
    schema      => 'mgwuser',
    name        => 'order2basic',
    from_schema => 'mgwuser',
    from_type   => 'book_order_t',
    to_schema   => 'sys',
    to_type     => 'mgw_basic_msg_t',
    transformation => 'mgwuser.mgw_xml_demo.order_to_basic(source.user_data)');
end;
/
